#ifndef _MAINDLG_CPP
#define _MAINDLG_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <CommCtrl.H>
#include <PrSht.H>

#include "../Resources/Resource.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../../SharedSource/NSWFL.H"
#include "../Source/Entry.H"
#include "../Source/Routines.H"
#include "../Source/Replication.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/SplashDlg.H"
#include "../Dialogs/ReplicationDlg.H"

#include "../Dialogs/TabAdvanced.H"
#include "../Dialogs/TabGeneral.H"
#include "../Dialogs/TabSecurity.H"
#include "../Dialogs/TabSQL.H"
#include "../Dialogs/TabSched.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//---------------------(Variable Declarations)
HWND MainDialog_hWnd = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK MainDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HWND StaticFrame_hWnd = NULL;
    static HWND TotalConnects_hWnd = NULL;
    static HWND Warnings_hWnd = NULL;
    static HWND Errors_hWnd = NULL;

	static HMENU SystemMenu = NULL;

	static int iLastWidth = 0;
	static int iLastHeight = 0;

	//--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG)
    {
        MainDialog_hWnd = xHandle;
		gbIsMainDialogOpen = true;

        SystemMenu = GetSystemMenu(xHandle, FALSE);
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1000, "About");

        SendMessage(xHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)gsTitleCaption);
        SendMessage(xHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_TRAYICON)) );

        MDI.Menu_hWnd      = LoadMenu(ghAppInstance, MAKEINTRESOURCE(IDR_MAINMENU));
		MDI.StatusBar_hWnd = CreateStatusWindow(WS_CHILD|WS_VISIBLE, "Ready", xHandle, 1);
        MDI.LogList_hWnd   = GetDlgItem(xHandle, IDC_LOGLIST);
		StaticFrame_hWnd   = GetDlgItem(xHandle, IDC_STATICFRAME);
        TotalConnects_hWnd = GetDlgItem(xHandle, IDC_TOTALCONNECTS);
        Warnings_hWnd      = GetDlgItem(xHandle, IDC_WARNINGS);
        Errors_hWnd        = GetDlgItem(xHandle, IDC_ERRORS);

        SetMenu(xHandle, MDI.Menu_hWnd);

		RECT WindowRECT;
        GetClientRect(xHandle, &WindowRECT);
        MoveWindow(MDI.LogList_hWnd, 0, 86, WindowRECT.right, ((WindowRECT.bottom-20) - 86), TRUE);
        MoveWindow(StaticFrame_hWnd, 0, 0, WindowRECT.right, 85, TRUE);

		Set_Long(TotalConnects_hWnd, giTotalConnects);
        Set_Long(Warnings_hWnd, giWarningCount);
        Set_Long(Errors_hWnd, giErrorCount);

		SetTimer(xHandle, 0, 500, NULL);

		CenterWindow(xHandle);

        if(gbDebugMode)
			CheckMenuItem(MDI.Menu_hWnd, ID_ADVANCED_DEBUGMODE, MF_BYCOMMAND|MF_CHECKED);
		else CheckMenuItem(MDI.Menu_hWnd, ID_ADVANCED_DEBUGMODE, MF_BYCOMMAND|MF_UNCHECKED);

		if(gbShowSplashScreen)
		{
			DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_SPLASH), xHandle, SplashDialog);
		}

        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND)
    {
        if(wParam == ID_ADVANCED_DEBUGMODE)
        {
            if(gbDebugMode)
            {
                CheckMenuItem(MDI.Menu_hWnd, ID_ADVANCED_DEBUGMODE, MF_BYCOMMAND|MF_UNCHECKED);
                gbDebugMode = false;
            }
            else{
                CheckMenuItem(MDI.Menu_hWnd, ID_ADVANCED_DEBUGMODE, MF_BYCOMMAND|MF_CHECKED);
                gbDebugMode = true;
            }
            return TRUE;
        }

		if(wParam == ID_SETTINGS_GENERATEREPLICATIONSQL)
        {
			CStatusDlg MyStatDlg;

			MyStatDlg.Load(Replication_hWnd, "Creating replications.", IDI_MAIN, false);
			ShowWindow(xHandle, SW_HIDE);
			ShowWindow(MainDialog_hWnd, SW_HIDE);
			MyStatDlg.Show();

			if(GenerateReplicationScripts(&MyStatDlg, gsReplicationDB, gsSQLDatabase, gsDefaultDBO, true))
			{
				MyStatDlg.SetText("Done generating the replication SQL.");
			}
			else MyStatDlg.SetText("An error occured while generating the replication SQL.");

			MyStatDlg.SetButtonText("Ok");

			MyStatDlg.EnableButton();

			while(MyStatDlg.IsDlgVisible())
			{
				Sleep(1);
			}

			MyStatDlg.Unload();
			ShowWindow(MainDialog_hWnd, SW_SHOW);
			ShowWindow(xHandle, SW_SHOW);

			SetForegroundWindow(xHandle);

			return TRUE;
        }

		if(wParam == ID_SETTINGS_REPLICATION)
        {
			DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_REPLICATION), xHandle, ReplicationDialog);
            return TRUE;
        }
        
		if(wParam == ID_CONNECTION_CONNECTNOW)
        {
			WriteSysLog("Opening manual connection to server.");
			gbConnectNow = true;
            return TRUE;
        }

        if(wParam == ID_CONNECTION_FORCEDISCONNECT)
        {
			if(gServer.bcConnected[CCI.iThisClient])
			{
				if(MessageBox(xHandle, "Disconnecting during an active session may result in data loss.\r\nAre you sure you want to forcfully disconnect from the server?", gsTitleCaption, MB_YESNO|MB_APPLMODAL) == IDYES)
				{
	                gServer.bcDisconnect[CCI.iThisClient] = true;
					return 0;
				}
			}
			else{
				MessageBox(xHandle, "No connection is currently active.", gsTitleCaption, MB_APPLMODAL);
			}

            return TRUE;
        }

        if(wParam == ID_SETTINGS_GENERALSETTINGS)
		{
            PROPSHEETPAGE psp[5];
            PROPSHEETHEADER psh;

            memset(&psp[0], '\0', sizeof(PROPSHEETPAGE));
            psp[0].dwSize      = sizeof(PROPSHEETPAGE);
            psp[0].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[0].hInstance   = ghAppInstance;
            psp[0].pszTemplate = MAKEINTRESOURCE(IDD_GENERALTAB);
            psp[0].pszIcon     = NULL;
            psp[0].pszTitle    = "General";
            psp[0].pfnDlgProc  = TabGeneralDialog;
            psp[0].lParam      = 0;
            psp[0].pfnCallback = NULL;
            psp[0].pcRefParent = NULL;

            memset(&psp[1], '\0', sizeof(PROPSHEETPAGE));
            psp[1].dwSize      = sizeof(PROPSHEETPAGE);
            psp[1].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[1].hInstance   = ghAppInstance;
            psp[1].pszTemplate = MAKEINTRESOURCE(IDD_SQLTAB);
            psp[1].pszIcon     = NULL;
            psp[1].pszTitle    = "SQL";
            psp[1].pfnDlgProc  = TabSQLDialog;
            psp[1].lParam      = 0;
            psp[1].pfnCallback = NULL;
            psp[1].pcRefParent = NULL;

            memset(&psp[2], '\0', sizeof(PROPSHEETPAGE));
            psp[2].dwSize      = sizeof(PROPSHEETPAGE);
            psp[2].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[2].hInstance   = ghAppInstance;
            psp[2].pszTemplate = MAKEINTRESOURCE(IDD_SECURITYTAB);
            psp[2].pszIcon     = NULL;
            psp[2].pszTitle    = "Security";
            psp[2].pfnDlgProc  = TabSecurityDialog;
            psp[2].lParam      = 0;
            psp[2].pfnCallback = NULL;
            psp[2].pcRefParent = NULL;

            memset(&psp[3], '\0', sizeof(PROPSHEETPAGE));
            psp[3].dwSize      = sizeof(PROPSHEETPAGE);
            psp[3].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[3].hInstance   = ghAppInstance;
            psp[3].pszTemplate = MAKEINTRESOURCE(IDD_SCHEDTAB);
            psp[3].pszIcon     = NULL;
            psp[3].pszTitle    = "Schedule";
            psp[3].pfnDlgProc  = TabSchedDialog;
            psp[3].lParam      = 0;
            psp[3].pfnCallback = NULL;
            psp[3].pcRefParent = NULL;

			memset(&psp[4], '\0', sizeof(PROPSHEETPAGE));
            psp[4].dwSize      = sizeof(PROPSHEETPAGE);
            psp[4].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[4].hInstance   = ghAppInstance;
            psp[4].pszTemplate = MAKEINTRESOURCE(IDD_ADVANCEDTAB);
            psp[4].pszIcon     = NULL;
            psp[4].pszTitle    = "Advanced";
            psp[4].pfnDlgProc  = TabAdvancedDialog;
            psp[4].lParam      = 0;
            psp[4].pfnCallback = NULL;
            psp[4].pcRefParent = NULL;

            memset(&psh, '\0', sizeof(PROPSHEETHEADER));
            psh.dwSize      = sizeof(PROPSHEETHEADER);
            psh.dwFlags     = PSH_USEHICON | PSH_PROPSHEETPAGE | PSH_NOAPPLYNOW;
            psh.hwndParent  = xHandle;
            psh.hInstance   = ghAppInstance;
            psh.hIcon       = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_TRAYICON));
            psh.pszCaption  = "Client Settings";
            psh.nPages      = 5;
            psh.nStartPage  = 0;
            psh.ppsp        = (LPCPROPSHEETPAGE) &psp;
            psh.pfnCallback = NULL;

            PropertySheet(&psh);

            SaveRegistryValues();

            return TRUE;
        }

        if(wParam == ID_HELP_ABOUT)
		{
            _AboutDialogInfo ADI;
    
            ADI.DisplayIcon  = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN));
            ADI.TitleCaption = gsTitleCaption;
            ADI.FileVersion  = gsFileVersion;
            ADI.BuildDate    = __DATE__;
            ADI.BuildTime    = __TIME__;
            ADI.CopyRight    = gsAppCopyRight;
            ADI.OwnerHandle  = xHandle;

            NetLogo(&ADI);
            return TRUE;
        }

        if(wParam == ID_FILE_CLOSEDLG)
        {
			gbIsMainDialogOpen = false;
			EndDialog(xHandle,0);
			DestroyWindow(xHandle);
            return TRUE;
        }

		return FALSE;
    }

	if(xMessage == WM_SIZE)
    {
		int nWidth = LOWORD(lParam);
		int nHeight = HIWORD(lParam);

		if(nWidth < 300)
			nWidth = iLastWidth;

		if(nHeight < 150)
			nHeight = iLastHeight;

		iLastWidth = nWidth;
		iLastHeight = nHeight;

		MoveWindow(MDI.LogList_hWnd, 0, 86, nWidth, (nHeight-20) - 86, TRUE);
		MoveWindow(MDI.StatusBar_hWnd, nWidth-20, nHeight-20, nWidth, nHeight, TRUE);
		MoveWindow(StaticFrame_hWnd, 0, 0, nWidth, 85, TRUE);

		return FALSE;//Return false of we process WM_SIZE.
    }

	//--------------------------------------------------------------------------

	if(xMessage == WM_TIMER)
    {
        Set_Long(TotalConnects_hWnd, giTotalConnects);
        Set_Long(Warnings_hWnd, giWarningCount);
        Set_Long(Errors_hWnd, giErrorCount);

		return true;
    }

	//--------------------------------------------------------------------------

	if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SYSCOMMAND) // Received A System Menu Message
    {
        if(LOWORD(wParam) == 1000)
        {
            _AboutDialogInfo ADI;
    
            ADI.DisplayIcon  = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN));
            ADI.TitleCaption = gsTitleCaption;
            ADI.FileVersion  = gsFileVersion;
            ADI.BuildDate    = __DATE__;
            ADI.BuildTime    = __TIME__;
            ADI.CopyRight    = gsAppCopyRight;
            ADI.OwnerHandle  = xHandle;

            NetLogo(&ADI);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE) 
    {
        gbIsMainDialogOpen = false;
        EndDialog(xHandle,0);
        DestroyWindow(xHandle);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

